#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <fcntl.h>      /* open */
//#include <unistd.h>     /* exit */
#include <sys/ioctl.h>  /* ioctl */

#define PORT_UNKNOWN            0
#define EUART_232_V1            1
#define EUART_422485_V1         2
#define EUART_A9610_232_V1      3
#define EUART_A9610_422485_V1   4

#include "serial_rdc_ioctl.h"
 
int main(int argc, char** argv)
{
    int result;
    
    int i;
    
    char    devicename[64];
    int     Device_tty;
    
    struct ioctl_param_PortInfo param_PortInfo;
    
    for (i = 0; i < 32; i++)
    {
        sprintf(devicename, "/dev/ttyRDC%d", i);
        
        Device_tty = open(devicename, O_RDWR | O_NOCTTY);
        if (Device_tty < 0)
        {
            printf("%s can not find \n", devicename);
        }
        else
        {
        
            result = ioctl(Device_tty, IOCTL_PortInfo, (unsigned long)&param_PortInfo);
            if (result < 0)
            {
                printf("%s IOCTL_PortInfo failed:%d \n", devicename, result);
            }
            else
            {
                printf("%s (B,D,F)=(%u,%u,%u) PortID:%u ",
                    devicename,
                    param_PortInfo.BusNumber,
                    param_PortInfo.DeviceNumber,
                    param_PortInfo.FunctionNumber,
                    param_PortInfo.PortID
                    );
                switch (param_PortInfo.PortType)
                {
                    case EUART_232_V1:
                    {
                        printf("EUART_232_V1 ");
                    }
                    break;
                    
                    case EUART_422485_V1:
                    {
                        printf("EUART_422485_V1 ");
                    }
                    break;
                    
                    case EUART_A9610_232_V1:
                    {
                        printf("EUART_A9610_232_V1 ");
                    }
                    break;
                    
                    case EUART_A9610_422485_V1:
                    {
                        printf("EUART_A9610_422485_V1 ");
                    }
                    break;
                    
                    case PORT_UNKNOWN:
                    default:
                    {
                        printf("port unknown ");
                    }
                    break;
                }
                
                printf("\n");
                
                printf("    ClockRate=%u, ClockDIV=%u, DMAEnable=%u",
                    param_PortInfo.ClockRate,
                    param_PortInfo.ClockDIV,
                    param_PortInfo.DMAEnable
                    );
            
                close(Device_tty);
                
                printf("\n");
            }
        }
    }
    
    return 0;
}
